;Copyright 1997, 1999 by Henter-Joyce, Inc.
;scripts in this file include parts from several different authors participating in script training class at HJ
;scripts purposely incorporate several different styles of gaining information for demonstration purposes
; jfw script for Juno version 1.38, 8/15/97, dlv
;Modified and updated 3/30/99 by DB
include "hjconst.jsh"
include "hjglobal.jsh"
Include "Juno.jsh"
include "juno.jsm"

Function AutoStartEvent()
	Let iPage = PAGE_OTHER			;default to this instead of 0
	Let iMute = FALSE
EndFunction

Void Function MuteToggle ()
				
;set up screen echo for mute
var
	int iNewEcho,
	int Safety
Let Safety = 0

If(iMute == TRUE) then
	Let iNewEcho = ECHO_NONE
Else
	Let iNewEcho = ECHO_HIGHLIGHTED
EndIf
while(GetScreenEcho() != iNewEcho)&& (Safety<2)
	ScreenEcho()
	Let Safety = (Safety +1)
Endwhile
EndFunction

Script ScriptFileName(); {Insert+Q}
ScriptAndAppNames ("Juno Email")
EndScript

Function SayFocusedWindow(); {Insert+;}
var
	int nID,
	handle hWnd,
	string sClass,
	int iNewPage,
	string sTitle,
	int iSafety

Let iSafety = 0

If(iMute == TRUE) then
	Return
EndIf

Let sClass = GetWindowClass(GlobalFocusWindow)
Let hWnd = GetRealWindow(GlobalFocusWindow)
Let nID = GetControlID (GlobalFocusWindow)

;wc1 = "JHGrid"
If(GetWindowClass(hWnd) == wc1) then		;Lets us treat JHGrid uniformly with other controls
	Let hWnd = GetRealWindow(GetParent(hWnd))
EndIf
Let sTitle = GetWindowName(hWnd)
If(sTitle == "") then
	If(nID > 1200) then							; first lets check if the page has changed
		Let iNewPage = PAGE_WRITE		;Write Screen
	Else
		Let iNewPage = PAGE_READ			;Read Screen
	EndIf
Else
;msg105 = "Address Book"
If(sTitle == msg105) then
		Let iNewPage = PAGE_ADDRESS			;Address Book
	Else
		Let iNewPage = PAGE_OTHER			;Dialogs
	EndIf
EndIf

If(iNewPage != iPage) then		;We have a new page so lets announce the fact
	Let iPage = iNewPage
	PerformScript PageIdentifier()
EndIf

;wc1 = "JHGrid"
If(sClass == wc1) then 
	Pause()							;allow the grid control to be refreshed
	Say (msg1, OT_CONTROL_NAME) ; "Message Listview"
	PerformScript SaySelectedText()
	Return
EndIf

;wc2 = "Edit"
;wc3 = "JHEdit_SS"
If((sClass == wc2) || (sClass == wc3)) then		;its an edit, lets find a title
	{Control+Home}
	If ((nID == RW_MESSAGE_EDIT)) then	;Received Editbox (Doesn't allow editing)
		Say (msg2, OT_MESSAGE) ; "Received Message"
		SayWindowTypeAndText (GetFocus ())
		Pause ()
		{Control+Home}
		{Home}
		Say (msg3, OT_MESSAGE) ; "Message Begins"
		While(GetLine ()=="")&& (iSafety <= 10) 	;move on past any blank lines
			Let iSafety = iSafety+1
			NextLine ()
		EndWhile
		SayLine ()	;Reads first text line of message
	Return
EndIf 
	If(nID == WW_MESSAGE_EDIT ) then
		Say (msg4, OT_MESSAGE) ; "Message"
	EndIf
EndIf		
If(iPage == PAGE_READ) &&((nID == RW_FOLDER_COMBO)) then		
;Folder Unique Combobox but RW_FOLDER_COMBO ID also found Elsewhere in Juno dialogs
	SayWindowTypeAndText (GetFocus ())
	Return
EndIf
If ((nID ==AD_ADDRESS_LIST )) then		;Address Extended Listbox
	Say (msg5, OT_CONTROL_NAME) ; "Address List"
	PerformScript SaySelectedText()
	Return
EndIf 
If ((nID == NL_NAMELIST_LIST )) then		;New List Dialog Box
	Say (msg6, OT_CONTROL_NAME) ; "Name/List"
	SayWindowTypeAndText (GetFocus ())
	Return
EndIf 
If ((nID == NL_MEMBERS_LIST && sTitle==msgSpellCheck )) then
	InvisibleCursor ()
	MoveToWindow (GetPriorWindow (GetPriorWindow(getfocus())))
	SpellString(GetWord())
	SayWindowTypeAndText (GetFocus())
	PCCursor()
	SpellString (GetWord())
	return
EndIf  

If ((nID == NL_MEMBERS_LIST && iPage==PAGE_ADDRESS )) then 		;New List Dialog Box
	Say (msg7, OT_MESSAGE) ; "Members of New List"
	SayWindowTypeAndText (GetFocus ())
	Return
EndIf
If (nID==1171)then		;Moves the pc cursor into the listbox, No way to tab to here
	SayWindowTypeAndText (GetFocus ())
	FindNextAttribute (ATTRIB_HIGHLIGHT)
	RoutePcToJAWS ()
	PcCursor ()
EndIf 
SayWindowTypeAndText (GetFocus ())
EndFunction

Script PageIdentifier () 
		;Establishes area we are in in Juno
	If(iPage == PAGE_WRITE) then
		say (msg8, OT_DIALOG_NAME) ; "Write page"
	Else 
	If(iPage == PAGE_READ) then
			say (msg9, OT_DIALOG_NAME) ; "Reed page"
		Else
		If(iPage == PAGE_ADDRESS) then
				say (msg10, OT_DIALOG_NAME) ; "Address book"
			EndIf
		EndIf
	EndIf
EndScript

Script ScreenSensitiveHelp()

var
	int nID
	Let nID = GetControlID (GetFocus ())
	
If ((nID == WW_TO_LIST ) || (nID == AD_TO_LIST)) then
	Say (msg11, OT_HELP) ; "This box contains a list of people you have selected to send this message to"
	Say (msg12, OT_HELP) ; "You can add to the list by typing in additional email addresses "
	Say (msg13, OT_HELP) ; "or adding others using the address book "
	Say (msg14, OT_HELP) ; "You can also highlight addresses listed and delete them from the list using the delete key"
	Say (msg15, OT_HELP) ; "Tab to go to the next control"
	Return
EndIf 
If ((nID ==WW_CC_LIST ) || (nID == AD_CC_LIST  )) then
	Say (msg11, OT_HELP) ; "This box contains a list of people you have selected to send copies of this message to"
	Say (msg12, OT_HELP) ; "You can add to the list by typing in additional email addresses "
	Say (msg13, OT_HELP) ; "or adding others using the Address Book "
	Say (msg14, OT_HELP) ; "You can also highlight addresses listed and delete them from the list using the delete key"
	Say (msg15, OT_HELP) ; "Tab to go to the next control"
	Return
EndIf 
If ((nID ==RW_MESSAGE_LIST)) then
	Say (msg16, OT_HELP) ; "This box contains a list of messages you have received"
	Say (msg17, OT_HELP) ; "Each line contains who the message is from"
 	Say (msg18, OT_HELP) ; "followed by subject, date, and status for the individual message "
	Say (msg19, OT_HELP) ; "You can use the up and down arrows to explore the list of received messages"
	Say (msg20, OT_HELP) ; "The body of the message is contained in the next control"
	Say (msg21, OT_HELP) ; "When you want to read the body of the selected message"
	Say (msg15, OT_HELP) ; "Tab to go to the next control"
	Return
EndIf 
If ((nID ==RW_FOLDER_COMBO)) then
	Say (msg22, OT_HELP) ; "This is a special type of combo box"
	Say (msg23, OT_HELP) ; "The box contains a list of all of your current folders"
 	Say (msg24, OT_HELP) ; "Use the up and down arrows to select the folder you want to access"
	Say (msg25, OT_HELP) ; "Tab to the next control to view the contents of the selected folder"
	Return
EndIf 
If ((nID ==AD_ADDRESS_LIST)) then
	Say (msg26, OT_HELP) ; "This box contains a list of addresses in your address book"
	Say (msg27, OT_HELP) ; "Each line contains the name, email address, and alias for an individual"
	Say (msg28, OT_HELP) ; "You can use the up and down arrows to explore the list of addresses"
	Say (msg29, OT_HELP) ; "Use Alt+S to add selected address to the list of people to send the current message to"
	Say (msg30, OT_HELP) ; "Use Alt+P to add selected address to the list of people to send a copy of the current message to"
	Say (msg15, OT_HELP) ; "Tab to go to the next control"
	Return
EndIf 
PerformScript ScreenSensitiveHelp ()
EndScript

Script SayNextLine()

var
	int nID
	Let nID = GetControlID (GetFocus ())
	;This script allows arrowing to read current line of box only while arrowing

If (nID == RW_FOLDER_COMBO) then
;Unique combo box selects and tabs with arrow movement.  This script causes it to appear to function 
;as a standard listbox 
	Let iMute = TRUE
	MuteToggle()
	{Down Arrow}
	pause()
	If (GetControlID(GetFocus()) != RW_FOLDER_COMBO) then
		{Shift+Tab}
		SayChunk()
	Else
		SayChunk()
	EndIf
	Let iMute = FALSE
	MuteToggle()
	Return
EndIf

If ((nID ==AD_TO_LIST) || (nID == AD_CC_LIST  ) || (nID == WW_TO_LIST ) 
|| (nID == WW_CC_LIST )) then
;default reads whole window on arrow movement, this isolates highlighted text to be spoken 
	NextLine ()
	SayChunk ()
	Return
EndIf
If ((nID ==RW_MESSAGE_EDIT)|| (nID == WW_MESSAGE_EDIT)) then
;default moves 1 line arrow movement but does not speak
	NextLine ()
	SayLine ()
	Return
Else 
	{Down Arrow}
EndIf
EndScript
	
Script SayPriorLine()

var
	int nID
	Let nID = GetControlID (GetFocus ())
	;This script allows arrowing to read current line of box only while arrowing

If (nID == RW_FOLDER_COMBO) then
;Unique combo box selects and tabs with arrow movement.  This script causes it to appear to function 
;as a standard listbox
	Let iMute = TRUE
	MuteToggle()
	{Up Arrow}
	pause()
	If (GetControlID(GetFocus()) != RW_FOLDER_COMBO) then
		{Shift+Tab}
		SayChunk()
	Else
		SayChunk()
	EndIf
	Let iMute = FALSE
	MuteToggle()
	Return
EndIf
If ((nID ==AD_TO_LIST) || (nID == AD_CC_LIST  ) || (nID == WW_TO_LIST ) 
|| (nID == WW_CC_LIST )) then
;default reads whole window on arrow movement, this isolates highlighted text to be spoken
	PriorLine ()
	SayChunk ()
	Return
EndIf
If ((nID ==RW_MESSAGE_EDIT)|| (nID == WW_MESSAGE_EDIT)) then
;default moves 1 line arrow movement but does not speak
	PriorLine ()
	SayLine ()
	Return
Else 
	{Up Arrow}

EndIf
EndScript

Script SayWindowTitle()
	;Gives us the Title bar and the area of Juno we are in
	If GetVerbosity() == 0 then
		Say (msg31, OT_MESSAGE) ; "Title = "
	EndIf
	say (GetWindowName (GetAppMainWindow (GlobalFocusWindow)), OT_APP_NAME)
	PerformScript PageIdentifier()
	If(iPage == PAGE_OTHER) then
		say (GetWindowName(GetRealWindow(GlobalFocusWindow)), OT_WINDOW_NAME)
	EndIf
EndScript

Script  ReadWindowHotKey()  
	;moves you to Read Window
{Alt+R}
If (iPage == PAGE_READ) then
	Say (msg32, OT_MESSAGE) ; "Already in Reed Page"
	Return
EndIf
If (iPage == PAGE_ADDRESS) then
	Say (msg33, OT_HELP) ; "You must exit the address book before you can go to the reed page of Juno"
EndIf
EndScript

Script  ToListboxHotkey()
	
	;Establishes HotKey to "To: ListBox" in Address Book & Write Window
var
int i,
HANDLE hGrip

Let i=0

If (iPage == PAGE_Write) then
	RouteJAWSToPc ()
	If (GetControlID (GetFocus ())==WW_TO_LIST ) then
		SayLine()
		Return
	EndIf
	;msg38 = "Subject:"
	If (FindString (GetFocus(), msg38, S_TOP, S_UNRESTRICTED)) then
		If (GetControlID(GetCurrentWindow())==WW_SUBJECT_STATIC ) then
			Let hGrip = GetCurrentWindow()
			while (i < 3)
				Let hGrip = GetPriorWindow(hGrip)
				Let i=i+1
			Endwhile
			MoveToWindow (hGrip)
			RoutePCToJAWS()
			PcCursor ()
			Say (msg34, OT_CONTROL_NAME) ; "To:"
		Else
			Say (msg35, OT_MESSAGE)	 ; "Could not move to to:"
		EndIf
	EndIf
	Return
EndIf
If (iPage == PAGE_ADDRESS) then
	If (GetControlID (GetFocus ())==AD_TO_LIST ) then
		SayLine()
		Return
	EndIf
	If (GetControlID (GetFocus ())==AD_ADDRESS_LIST) then
		{Tab}
		Pause ()
	EndIf
	MoveToControl (GetRealWindow (GetFocus ()), AD_TO_LIST) 
	Say (msg34, OT_CONTROL_NAME) ; "To:"
	RoutePcToJAWS ()
	PcCursor ()
EndIf
EndScript

Script  CcListboxHotkey() 

	;Establishes HotKey to "Cc ListBox" in Address Book & Write Window
var
	int i,
	Handle hGrip,
	int nID

	Let i=0

If (iPage == PAGE_Write) then
	RouteJAWSToPc ()
	;msg38 = "Subject:"
	If (FindString (GetFocus(), msg38, S_TOP, S_UNRESTRICTED)) then
		If (GetControlID(GetCurrentWindow())==WW_SUBJECT_STATIC ) then
			Let hGrip = GetCurrentWindow()
			while (i < 2)
				Let hGrip = GetPriorWindow(hGrip)
				Let i=i+1
			Endwhile
			MoveToWindow (hGrip)
			RoutePCToJAWS()
			PcCursor ()
			Say (msg36, OT_CONTROL_NAME) ; "Cc:"
		Else
			Say (msg37, OT_MESSAGE)	 ; "Could not move to Cc:"
		EndIf
	EndIf
	Return
EndIf
If (iPage == PAGE_ADDRESS) then 
	If (GetControlID (GetFocus ())==AD_CC_LIST ) then
		SayLine()
		Return
	EndIf
	If (GetControlID (GetFocus ())==AD_ADDRESS_LIST) then
		{Tab}
		Pause ()
		MoveToControl (GetRealWindow (GetFocus ()), AD_CC_LIST)
		RoutePcToJAWS ()
		PcCursor ()
		Return
	Else
	MoveToControl (GetRealWindow (GetFocus ()), AD_CC_LIST)
	RoutePcToJAWS ()
	PcCursor ()
	EndIf
EndIf
EndScript

Script  SubjectEditboxHotkey()

	;Establishes HotKey to "Subject EditBox" in Write Window
var
int i,
HANDLE hGrip,
int nID

Let i=0
Let nID = GetControlID (GetFocus ())

If (iPage == PAGE_WRITE) then 
	If  ((nID ==WW_SUBJECT_EDIT)) Then
		SayLine ()
		Return
	Else
		RouteJAWSToPc ()
		If (FindString (GetFocus(), msgSubject, S_TOP, S_UNRESTRICTED)) then
			If (GetControlID(GetCurrentWindow())==WW_SUBJECT_STATIC ) then
				Let hGrip = GetCurrentWindow()
				while (i < 1)
					Let hGrip = GetPriorWindow(hGrip)
					Let i=i+1
				Endwhile
		
				MoveToWindow (hGrip)
				RoutePCToJAWS()
				PcCursor ()
				Say (msg38, OT_CONTROL_NAME)	 ; "Subject:"
			Else
				Say (msg39, OT_MESSAGE)	 ; "Could not move to Subject:"
			EndIf
		EndIf
	EndIf
EndIf
EndScript

Script  MessageReadHotkey() ;Control+M

	;Establishes HotKey to read messages in Read & Write Windows
var
int i,
HANDLE hGrip,
int nID

Let i=0
Let nID = GetControlID (GetFocus ())

If(iPage == PAGE_READ) || (iPage == PAGE_Write) then
	RouteJAWSToPc ()
	If(iPage == PAGE_WRITE) then
		If  ((nID ==WW_MESSAGE_EDIT)) Then	
			Say (msg40, OT_MESSAGE) ; "Message:"
			Say (msg41, OT_MESSAGE) ; "Current Line Reeds"
			SayLine ()
			Return
		EndIf
		;msg40 = "Message:"
		If (FindString (GetFocus(), msg40, S_TOP, S_UNRESTRICTED)) then 			If (GetControlID(GetCurrentWindow())==WW_MESSAGE_STATIC ) then
				Let hGrip = GetCurrentWindow()
				While (i < 1)
					Let hGrip = GetNextWindow(hGrip)
					Let i=i+1
				Endwhile
				MoveToWindow (hGrip)
				RoutePCToJAWS()
				PcCursor ()
				Say (msg42, OT_MESSAGE) ; "Message Begins"
				SayLine ()
				Return
			EndIf
		EndIf
	EndIf
	If(iPage == PAGE_READ) then
		If  ((nID ==RW_MESSAGE_EDIT)) Then	;
			Say (msg43, OT_CONTROL_NAME) ; "Received Message"
			Say (msg41, OT_MESSAGE) ; "Current line reeds"
			SayLine ()
			Return
		EndIf
		;msg44 = "Folder:"
		If (FindString (GetFocus(), msg44, S_TOP, S_UNRESTRICTED)) then 
			If (GetControlID(GetCurrentWindow())==RW_FOLDER_STATIC ) then
				Let hGrip = GetCurrentWindow()
				while (i <2)
					Let hGrip = GetNextWindow(hGrip)
					Let i=i+1
				Endwhile
				MoveToWindow (hGrip)
				RoutePCToJAWS()
				PcCursor ()
			EndIf
		Return
		EndIf
	EndIf
Else
	{Control + M}
EndIf
EndScript

Script  FolderComboHotkey()

	;Establishes HotKey to "Folder Combobox" in Read Window
var
int i,
HANDLE hGrip,
int nID,
handle hwnd

Let i=0

If(iPage == PAGE_READ) then
	If (GetControlID(GetCurrentWindow())==RW_FOLDER_COMBO ) Then
		Say (msg44, OT_CONTROL_NAME) ; "Folder:"
		SayChunk ()
		Return
	EndIf	
	RouteJAWSToPc ()
	;msg44 = "Folder:"
	If (FindString (GetFocus(), msg44, S_TOP, S_UNRESTRICTED)) then 
		If (GetControlID(GetCurrentWindow())==RW_FOLDER_STATIC ) then
			Let hGrip = GetCurrentWindow()
			While (i <5)
				Let hGrip = GetNextWindow(hGrip)
				Let i=i+1
			Endwhile
			MoveToWindow (hGrip)
			RoutePCToJAWS()
			PcCursor ()
		EndIf
	EndIf
	Return
Else
		{Control+F}
EndIf

EndScript

Script  MessageStatusHotKey()
	;Establishes HotKey to read satus of messages in Read & Write Windows
SaveCursor()
InvisibleCursor()
If(iPage == PAGE_Write) then
;msg34 = "To:"
	If (FindString (GetFocus(), msg34, S_TOP, S_UNRESTRICTED)) then 
		If (GetControlID(GetCurrentWindow())==WW_TO_STATIC ) then
			PriorLine ()
			SayFromCursor ()
			RestoreCursor()
		EndIf
		Return
	EndIf
EndIf
If(iPage == PAGE_READ) then
	;msg44 = "Folder:"
	If (FindString (GetFocus(), msg44, S_TOP, S_UNRESTRICTED)) then 
		If (GetControlID(GetCurrentWindow())==RW_FOLDER_STATIC) then
			MoveToWindow(GetPriorWindow(GetCurrentWindow()))
			SayFromCursor()
			RestoreCursor()
		EndIf
		Return
	EndIf
EndIf
If(iPage == PAGE_ADDRESS)|| (iPage == PAGE_OTHER)then
	{Alt+N}
EndIf
EndScript

Script  MessageListBoxHotkey()

	;Establishes HotKey to "Message ListBox" in Read Window
var
int nSuccess,
int nID,
HANDLE hGrip

Let nID = GetControlID (GetFocus ())

If(iPage == PAGE_READ) then
	If (GetControlID(GetCurrentWindow())==RW_MESSAGE_LIST ) then
		SayLine()
	EndIf
	RouteJAWSToPc ()
	; msg104 = "Status"
	If (FindString (GetFocus(), msg104, S_TOP, S_UNRESTRICTED)) then 
		If (GetControlID(GetCurrentWindow())==RW_MESSAGE_LIST ) then
			Let hGrip = GetCurrentWindow()
			Let nSuccess = FindNextAttribute (ATTRIB_HIGHLIGHT)
			If (nSuccess == WAS_SUCCESSFUL) then
				RoutePcToJAWS ()
				PcCursor ()			
			Else					
				Say (msg45, OT_MESSAGE)			 ; "No messages in folder"
			EndIf
		EndIf
	EndIf
	Return
EndIf
EndScript

; * * *
;Although Juno assigns hotkeys for buttons, the key combination only selects the button
;it does not execute the command represented by the buttons.  The following scripts cause
; the key combinations to execute the appropriate commands.

Script  WriteWindowHotKey() ;Alt+W
	;Moves you to Write Window
{Alt+W}
If (iPage == PAGE_WRITE) then
	Say (msg46, OT_MESSAGE) ; "Already in Write Page"
	Return
EndIf
If (iPage == PAGE_ADDRESS) then
	Say (msg47, OT_HELP) ; "You must exit the address book before you can go to the write page of Juno"
EndIf
EndScript

Script  AddressBookHotkey() ;Alt+A

	;Enables default shortcuts to go to Address Book to work in Read & Write Windows
var
	int nID

Let nID = GetControlID (GetFocus ())

If(iPage == PAGE_READ) ||(iPage == PAGE_WRITE) then
	{Alt+A}
	Pause ()
	If (GetControlID (GetFocus ())==RW_ADDRESSBOOK_BUTTON )
	||  (GetControlID (GetFocus ())==WW_ADDRESSBOOK_BUTTON )Then
		{SpaceBar}
	EndIf
	Return
EndIf
	;Establishes HotKey to "Address List" in Address Book
If(iPage == PAGE_ADDRESS) then
	If (GetWindowName (GetRealWindow (GetFocus())) == msgAddressBook) then
		MoveToControl (GetRealWindow (GetFocus ()),AD_ADDRESS_LIST) 
		NextLine ()
		RoutePcToJAWS ()
		PcCursor ()
		Return
	EndIf
	If  ((nID ==AD_ADDRESS_LIST)) Then
		Say (msg48, OT_MESSAGE) ; "Already in Message List view"
		Say (msg49, OT_MESSAGE) ; "Selected Text Is"
		SayLine ()
		Return
	EndIf
EndIf
EndScript

Script  SpellCheckHotkey()
	;Enables Default Hot Key to check spelling in Write window
{Alt+L}
Pause ()
If (GetControlID (GetFocus ())==WW_SPELLCHECK_BUTTON )
Then
	RouteJAWSToPc ()
	LeftMouseButton ()
EndIf
EndScript

Script ClearAndCopyHotkeys ()
	
;Enables Default Hot Key clear message in write window & copy message in read window
{Alt+C}
Pause ()
If (GetControlID (GetFocus ())==WW_CLEAR_BUTTON ) 
||  (GetControlID (GetFocus ())==RW_COPY_BUTTON )Then
	{Spacebar}
EndIf
EndScript

Script  PrintHotkey()
	;Enables Default Hot Key to print in Read & Write Windows
{Alt+P}
Pause ()
If (GetControlID (GetFocus ())==RW_PRINT_BUTTON ) 
||  (GetControlID (GetFocus ())==WW_PRINT_BUTTON )Then
	{Spacebar}
EndIf
EndScript

Script  SendHotkey()
	;Enables Default Hot Key to send mail in Write Window
{Alt+S}
Pause ()
If(iPage == PAGE_Write) then
	If (GetControlID (GetFocus ())==WW_SENDMAIL_BUTTON )Then
		{Spacebar}
	Else
	SayString (msg50) ; "You Must Address The Message Before It Can Be Sent"
	EndIf
Endif
EndScript

Script  ReplyHotkey()
	;Enables Default Hot Key to reply to message in read window
{Alt+Y}
Pause ()
If (GetControlID (GetFocus ())==RW_REPLY_BUTTON )Then
	{Spacebar}
EndIf
EndScript

Script  ForwardHotkey()
	;Enables Default Hot Key to forward messages in read window
{Alt+O}
Pause ()
If (GetControlID (GetFocus ())==RW_FORWARD_BUTTON )Then
	{Spacebar}
EndIf
EndScript

Script  DeleteHotkey()
	;Enables Default Hot Key to delete messages in read window
{Alt+D}
Pause ()
If (GetControlID (GetFocus ())==RW_DELETE_BUTTON )Then
	{Spacebar}
EndIf
EndScript

Script  MoveHotkey()
	;Enables Default Hot Key to move messages to another folder in read window
{Alt+M}
Pause ()
If (GetControlID (GetFocus ())==RW_MOVE_BUTTON )Then
	{Spacebar}
EndIf
EndScript

Script  GetNewMailHotkey() ;Alt+G
	;Enables Default Hot Key to get new mail in read window
{Alt+G}
Pause ()
If (GetControlID (GetFocus ())==RW_GET_BUTTON )Then
	{Spacebar}
EndIf
EndScript

Script HotKeyHelp()

If(iPage == PAGE_ADDRESS) then
	Say (msg51, OT_HELP) ; "You are in the address book of Juno"
	; msg52 = "You can Tab through the controls " 
	; msg53 = " or jump using the following hot keys"
	Say (msg52+ msg53, OT_HELP)
	Say (msg54, OT_HELP) ; "To add a new name to your address book, use Alt+N"
	Say (msg55 + GetScriptKeyName ("SpellCheckHotkey"), OT_HELP) ; "To creat a new distribution list, use Alt+L"
	Say (msg56, OT_HELP) ; "To edit the current address, use Alt+E"
	Say (msg57 + GetScriptKeyName ("DeleteHotkey"), OT_HELP) ; "To delete the current address, use Alt+D"
	Say (msg58, OT_HELP) ; "To find an address, use Alt+F"
	Say (msg59, OT_HELP) ; "To select the okay button, Use Alt+O"
	Say (msg60, OT_HELP) ; "To Cancel use of the address book, Use Alt+C"
	Say (msg61, OT_HELP) ; "To go to juno help, Use Alt+H"
	Say (msg62, OT_HELP) ; "To go to the address listbox, use Control+Eigh"
	Say (msg63 + GetScriptKeyName ("ToListboxHotkey"), OT_HELP) ; "To go to the To: listbox, Use Control+T"
	Say (msg64 + GetScriptKeyName ("CcListboxHotkey"), OT_HELP) ; "To go to the Cc: listbox, Use Alt+Shift+C"
	Say (msg65+ GetScriptKeyName ("AddressBookHotkey"), OT_HELP) ; "To go to the Address List, Use Alt+A"
	Return
EndIf
If(iPage == PAGE_WRITE) then
	Say (msg66, OT_HELP) ; "You are in the write window of Juno"
	; msg52 = "You can Tab through the controls " 
	; msg53 = " or jump using the following hot keys"
	Say (msg52+ msg53, OT_HELP)
	Say (msg67 + GetScriptKeyName ("SpellCheckHotkey"), OT_HELP) ; "To run Spell Check, use Alt+L"
	Say (msg68 + GetScriptKeyName ("ClearAndCopyHotkeys"), OT_HELP) ; "To clear the message window, use Alt+C"
	Say (msg69 + GetScriptKeyName ("PrintHotkey"), OT_HELP) ; "To print the message, use Alt+P"
	Say (msg70 + GetScriptKeyName ("SendHotkey"), OT_HELP) ; "To send mail, Use Alt+S"
	Say (msg71 + GetScriptKeyName ("AddressBookHotkey"), OT_HELP) ; "To go to the address book, use Alt+Eigh"
	Say (msg63 + GetScriptKeyName ("ToListboxHotkey"), OT_HELP) ; "To go to the To: listbox, Use Control+T"
	Say (msg64 + GetScriptKeyName ("CcListboxHotkey"), OT_HELP) ; "To go to the Cc: listbox, Use Alt+Shift+C"
	Say (msg72 + GetScriptKeyName ("SubjectEditboxHotkey"), OT_HELP) ; "To go to the Subject Edit box, Use Alt+U"
	Say (msg73 +GetScriptKeyName ("MessageReadHotkey"), OT_HELP) ; "To go to the Message Edit box, Use Control+M"
	Say (msg74 + GetScriptKeyName ("MessageStatusHotKey"), OT_HELP) ; "To find out the number of new messages in your outbox, Use Alt+N"
	Say (msg75 + GetScriptKeyName ("ReadWindowHotKey"), OT_HELP) ; "To go to the Reed Window of Juno, Use Alt+R"
	Say (msg76 + GetScriptKeyname ("AddressBookHotkey"), OT_HELP) ; "To go to the Address Book, Use Alt+A"
	Say (msg77 + GetScriptKeyName ("MessageStatusHotKey"), OT_HELP) ; "To read the status of messages, Use Alt+N"
	Return
EndIf
If(iPage == PAGE_READ) then
	Say (msg78, OT_HELP) ; "You are in the reed window of Juno"
	; msg52 = "You can Tab through the controls " 
	; msg53 = " or jump using the following hot keys"
	Say (msg52 + msg53, OT_HELP)
	Say (msg79 + GetScriptKeyName ("ReplyHotkey"), OT_HELP) ; "To reply to the current message, use Alt+Y"
	Say (msg80 + GetScriptKeyName ("ForwardHotkey"), OT_HELP) ; "To forward the current message, use Alt+O"
	Say (msg81 + GetScriptKeyName ("DeleteHotkey"), OT_HELP) ; "To delete the current message, use Alt+D"
	Say (msg69 + GetScriptKeyName ("PrintHotkey"), OT_HELP) ; "To print the message, use Alt+P"
	Say (msg82 + GetScriptKeyName ("MoveHotkey"), OT_HELP) ; "To move the message to another folder, Use Alt+M"
	Say (msg83 + GetScriptKeyName ("ClearAndCopyHotkeys"), OT_HELP) ; "To copy the message to another folder, Use Alt+C"
	Say (msg84 + GetScriptKeyName ("GetNewMailHotkey")	, OT_HELP) ; "To get new mail, Use Alt+G"
	Say (msg71 + GetScriptKeyName ("AddressBookHotkey"), OT_HELP) ; "To go to the address book, use Alt+Eigh"
	Say (msg85 + GetScriptKeyname ("FolderComboHotkey"), OT_HELP) ; "To go to the Folder Combo Box, Use Control+F"
	Say (msg86 + GetScriptKeyName ("MessageListBoxHotkey"), OT_HELP) ; "To go to the Recieved Messages List Box, Use Control+E"
	Say (msg87 + GetScriptKeyName ("MessageReadHotkey"), OT_HELP) ; "To go to the Message Edit box, Use Control+M"
	Say (msg77 + GetScriptKeyName ("MessageStatusHotKey"), OT_HELP) ; "To read the status of messages, Use Alt+N"
	Say (msg76 + GetScriptkeyName ("AddressBookHotkey"), OT_HELP) ; "To go to the Address Book, Use Alt+A"
	Say (msg88 + GetScriptKeyName ("WriteWindowHotKey"), OT_HELP) ; "To go to the Write Window of Juno, Use Alt+W"
	Return
EndIf
EndScript

Script SayCharacter ()
Var
	int nID

	Let nID = GetControlID (GetFocus ())
If (nID==RW_ADDRESSBOOK_BUTTON ) || (nID==WW_ADDRESSBOOK_BUTTON )Then
	Say (msg89, OT_BUFFER) ; "a"
	Return
Endif
If (nID==WW_SPELLCHECK_BUTTON) || (nID==AD_LIST_BUTTON )then
	Say (msg90, OT_BUFFER) ; "l"
	Return
Endif
If (nID==WW_CLEAR_BUTTON )||(nID==RW_COPY_BUTTON ) || (nID==AD_CANCEL_BUTTON ) then
	Say (msg91, OT_BUFFER) ; "c"
	Return
Endif
If (nID==WW_PRINT_BUTTON )
	||  (nID==RW_PRINT_BUTTON ) || (nID==AD_COPY_BUTTON ) Then
	Say (msg92, OT_BUFFER) ; "p"
	Return
Endif
If (nID==WW_SENDMAIL_BUTTON ) || (nID==AD_SEND_BUTTON ) then
	Say (msg93, OT_BUFFER) ; "s"
	Return
Endif
If (nID==RW_REPLY_BUTTON )then
	Say (msg94, OT_BUFFER) ; "y"
	Return
Endif
If (nID==RW_FORWARD_BUTTON ) || (nID==AD_OK_BUTTON ) then
	Say (msg95, OT_BUFFER) ; "o"
	Return
Endif
If (nID==RW_DELETE_BUTTON ) || (nID==AD_DELETE_BUTTON ) then
	Say (msg96, OT_BUFFER) ; "d"
	Return
Endif
If (nID==RW_MOVE_BUTTON )then
	Say (msg97, OT_BUFFER) ; "m"
	Return
Endif
If (nID==RW_GET_BUTTON )then
	Say (msg98, OT_BUFFER) ; "g"
	Return
Endif
If (nID==AD_NAME_BUTTON ) then
	Say (msg99, OT_BUFFER) ; "n"
	Return
Endif
If (nID==AD_EDIT_BUTTON ) then
	Say (msg100, OT_BUFFER) ; "e"
	Return
Endif
If (nID==AD_FIND_BUTTON ) then
	Say (msg101, OT_BUFFER) ; "f"
	Return
Endif
If (nID==AD_HELP_BUTTON ) then
	Say (msg102, OT_BUFFER) ; "h"
	Return
Endif
If (nID==AD_REMOVE_BUTTON ) then
	Say (msg103, OT_BUFFER); "r"
	Return
Endif
SayCharacter ()
EndScript
